class EnergyManager
  @@render_targets = {}
  def initialize(current, minimum, maximum)
    @maximum = maximum
    @minimum = minimum
    @current = current

    @rt_size = {w: 160, h: 20}
    @rt_name = :"energy_manager_rt__#{self.object_id}" #make sure each energy manager has a unique render target name

    @show_text = true
  end

  def full?
    @current == @maximum
  end

  def empty?
    @current <= @minimum
  end

  def tick(args)
  end

  def draw(args)
    size = @rt_size
    size.w = 160
    size.h = 20
    args.outputs[@rt_name].transient!
    args.outputs[@rt_name].w = @rt_size.w
    args.outputs[@rt_name].h = @rt_size.h

    text_x = (size.w / 2)
    text = "#{@current}/#{@maximum}"
    output = [
      {x: 0, y: 0, w: size.w, h: size.h, primitive_marker: :solid}.merge(Color::WHITE),
      {x: 0, y: 0, w: (@current / @maximum) * size.w, h: size.h, primitive_marker: :solid}.merge(Color::RED),
    ]
    if @show_text
      output << {x: text_x, y: 16, text: text, alignment_enum: 1, size_px: 16, primitive_marker: :label}.merge(Color::BLACK)
    end

    output << {x: 0, y: 0, w: size.w, h: size.h, primitive_marker: :border}.merge(Color::WHITE)

    args.outputs[@rt_name].primitives << output

    {w: @rt_size.w, h: @rt_size.h, primitive_marker: :sprite, path: @rt_name}
  end

  def add!(value)
    @current = (@current + value).clamp(@minimum, @maximum)
    self
  end

  def subtract!(value)
    @current = (@current - value).clamp(@minimum, @maximum)
    self
  end
end